/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerContentDAO.java,v 1.4 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerBaseTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;

/**
 * @author Manpreet Minhas
 */
public class TestBehaviourComposerContentDAO extends BehaviourComposerBaseTestCase {
	
	protected BehaviourComposerContent behaviourComposerContent;
	protected IBehaviourComposerContentDAO behaviourComposerContentDAO;
	
	public TestBehaviourComposerContentDAO(String name){
		super(name);
	}

	public void setUp()throws Exception{
		super.setUp();
		behaviourComposerContentDAO = (IBehaviourComposerContentDAO)context.getBean("behaviourComposerContentDAO");
	}
	
	public void testAddBehaviourComposerContent() throws Exception {
		long newId = getMaxContentId() + 1;
		String title = "Trial Content";
		String instructions = "Trial Instructions";
		behaviourComposerContent = new BehaviourComposerContent(new Long(newId),title,instructions);
		behaviourComposerContentDAO.insert(behaviourComposerContent);
		Long contentId = behaviourComposerContent.getContentID();
		assertNotNull(contentId);
		assertEquals(contentId.longValue(), newId);
	}

	public void testAddGetContentByID() throws Exception {
		behaviourComposerContent = behaviourComposerContentDAO.getContentByID(TEST_CONTENT_ID);
		assertEquals(behaviourComposerContent.getTitle(), TEST_CONTENT_TITLE);
		assertEquals(behaviourComposerContent.getInstruction(), TEST_CONTENT_INSTRUCTIONS);
	}

}
