/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: IBehaviourComposerSessionDAO.java,v 1.5 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import java.util.List;

import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * @author Manpreet Minhas
 */
public interface IBehaviourComposerSessionDAO extends IBaseDAO {
	
	/**
	 * Returns the session record corresponding to the
	 * given <code>sessionID</code>
	 * 
	 * @param sessionID The <code>session_id</code> to be looked up
	 * @return BehaviourComposerSession The required populated object
	 */
	public BehaviourComposerSession getSessionByID(Long sessionID);

	/**
	 * @param behaviourComposerSession
	 */
	public void createSession(BehaviourComposerSession behaviourComposerSession);
	
    public List getBehaviourComposerSessionByContentID(Long contentID);
}
