/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerSession.java,v 1.5 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerBaseTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerContentDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerSessionDAO;

/**
 * @author Manpreet Minhas
 */
public class TestBehaviourComposerSession extends BehaviourComposerBaseTestCase {
	
	protected BehaviourComposerSession behaviourComposerSession;
	protected BehaviourComposerContent behaviourComposerContent;
	
	protected IBehaviourComposerContentDAO behaviourComposerContentDAO;
	protected IBehaviourComposerSessionDAO behaviourComposerSessionDAO;
	
	public TestBehaviourComposerSession(String name){
		super(name);
	}

	public void setUp() throws Exception{
		super.setUp();
		behaviourComposerSessionDAO = (BehaviourComposerSessionDAO)context.getBean("behaviourComposerSessionDAO");
		behaviourComposerContentDAO = (BehaviourComposerContentDAO)context.getBean("behaviourComposerContentDAO");
	}
	public void testAddBehaviourComposerSession(){
		behaviourComposerContent = behaviourComposerContentDAO.getContentByID(new Long(1));
		behaviourComposerSession = new BehaviourComposerSession(new Long(1),BehaviourComposerSession.INCOMPLETE);
		behaviourComposerSessionDAO.insert(behaviourComposerSession);
		assertNotNull(behaviourComposerSession.getSessionID());
	}
	public void testGetSessionByID(){
		behaviourComposerSession = behaviourComposerSessionDAO.getSessionByID(new Long(1));
		assertEquals(behaviourComposerSession.getStatus(), new Integer(1));
	}

}
