/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerReportDAO.java,v 1.5 2006/04/06 06:41:33 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerReport;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerReportDAO;

/**
 * @author Manpreet Minhas
 */
public class BehaviourComposerReportDAO extends BaseDAO implements
		IBehaviourComposerReportDAO {
	
	private static final String TABLENAME ="tl_kkbc10_report";
	private static final String FIND_BY_SUBMISSION = "from " + TABLENAME +
											   " in class " + BehaviourComposerReport.class.getName() + 
											   " where submission_id=?" ;

	/**
	 * (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerReportDAO#getReportByID(java.lang.Long)
	 */
	public BehaviourComposerReport getReportByID(Long reportID) {
		return (BehaviourComposerReport)super.find(BehaviourComposerReport.class,reportID);
	}
	
	/**
	 * (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerReportDAO#getReportBySubmissionID(java.lang.Long)
	 */
	public BehaviourComposerReport getReportBySubmissionID(Long submissionID){
		
		List list = this.getHibernateTemplate().find(FIND_BY_SUBMISSION,submissionID);
		if(list!=null)
			return (BehaviourComposerReport)list.get(0);
		else
			return null;		
	}	

	/* (non-Javadoc)
	 * @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerReportDAO#updateReport(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerReport)
	 */
	public void updateReport(BehaviourComposerReport report) {
		this.getSession().setFlushMode(FlushMode.AUTO);
		getHibernateTemplate().update(report);
		getHibernateTemplate().flush();
	}
}
