<?php

/**
 * This page is called from LAMS so it can trigger a call back
 * to get a specific user's gradebook mark
 * The pass-in parameters are un, lsId  ts and hs.
 * un means username, ts means timestamp and hs means hash.
 * The plain text of the hash should be lower case string of
 * ts.trim()+un.trim()+serverId+serverKey. The hash algorithm
 * is sha1.
 * If the hash is not matched to the result calculated, then a
 * http error code should be returned.
 * Moodle's admin should be responsible for correctly setting
 * serverId and serverKey
 */
include_once('../../config.php');
include_once($CFG->libdir.'/datalib.php');
include_once('lib.php');
global $DB;

if(!isset($CFG->lamslesson_serverid)||!isset($CFG->lamslesson_serverkey)) {
    header('HTTP/1.1 401 Unauthenticated');
    exit(1);
}
$plaintext = trim($_GET['ts']).trim($_GET['un']).trim($CFG->lamslesson_serverid).trim($CFG->lamslesson_serverkey);
$hash = sha1(strtolower($plaintext));

if($hash!=$_GET['hs']){
  header('HTTP/1.1 401 Unauthenticated');
  exit(1);
}

//OK, the caller is authenticated. Now let's fulfill its request.
// and make Moodle get the latest marks for this user in this lesson

$lsid = $_GET['lsId'];
$user = $DB->get_record('user', array('username'=>$_GET['un']));
if(!$user){
  header('HTTP/1.1 401 Unauthenticated');
  exit(1);
}

$lamslesson  = $DB->get_record('lamslesson', array('lesson_id' => $lsid), '*', MUST_EXIST);

$gradebookmark = lamslesson_get_lams_outputs($user->username,$lamslesson,$user->username);

?>