/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.signup.action;

import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.tool.signup.model.SignupOrganisation;
import org.lamsfoundation.lams.tool.signup.service.SignupService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AdminAction
extends Action {
    private static Logger log = Logger.getLogger(AdminAction.class);
    private static SignupService signupService = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String method;
            if (signupService == null) {
                WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
                signupService = (SignupService)wac.getBean("signupService");
            }
            if (StringUtils.equals((String)(method = WebUtil.readStrParam((HttpServletRequest)request, (String)"method", (boolean)true)), (String)"edit")) {
                return this.edit(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"add")) {
                return this.add(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"delete")) {
                return this.delete(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"list")) {
                // empty if block
            }
            List signupOrganisations = signupService.getSignupDAO().getSignupOrganisations();
            request.setAttribute("signupOrganisations", (Object)signupOrganisations);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            request.setAttribute("error", (Object)e.getMessage());
        }
        return mapping.findForward("admin-list");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SignupOrganisation signup;
        Integer soid = WebUtil.readIntParam((HttpServletRequest)request, (String)"soid", (boolean)false);
        if (soid != null && soid > 0 && (signup = (SignupOrganisation)signupService.getSignupDAO().find(SignupOrganisation.class, soid)) != null) {
            DynaActionForm adminForm = (DynaActionForm)form;
            adminForm.set("signupOrganisationId", (Object)signup.getSignupOrganisationId());
            adminForm.set("organisationId", (Object)signup.getOrganisation().getOrganisationId());
            adminForm.set("addToLessons", (Object)signup.getAddToLessons());
            adminForm.set("addAsStaff", (Object)signup.getAddAsStaff());
            adminForm.set("addWithAuthor", (Object)signup.getAddWithAuthor());
            adminForm.set("addWithMonitor", (Object)signup.getAddWithMonitor());
            adminForm.set("courseKey", (Object)signup.getCourseKey());
            adminForm.set("blurb", (Object)signup.getBlurb());
            adminForm.set("disabled", (Object)signup.getDisabled());
            adminForm.set("context", (Object)signup.getContext());
            List organisations = signupService.getSignupDAO().getOrganisationCandidates();
            request.setAttribute("organisations", (Object)organisations);
            return mapping.findForward("admin-add");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block7: {
            DynaActionForm adminForm = (DynaActionForm)form;
            if (adminForm.get("organisationId") != null && (Integer)adminForm.get("organisationId") > 0) {
                ActionMessages errors = new ActionMessages();
                if (!StringUtils.equals((String)adminForm.getString("courseKey"), (String)adminForm.getString("confirmCourseKey"))) {
                    errors.add("courseKey", new ActionMessage("error.course.keys.unequal"));
                }
                if (signupService.getSignupDAO().contextExists((Integer)adminForm.get("signupOrganisationId"), adminForm.getString("context"))) {
                    errors.add("context", new ActionMessage("error.context.exists"));
                }
                if (!errors.isEmpty()) {
                    this.saveErrors(request, errors);
                    break block7;
                } else {
                    SignupOrganisation signup;
                    if (adminForm.get("signupOrganisationId") != null && (Integer)adminForm.get("signupOrganisationId") > 0) {
                        signup = (SignupOrganisation)signupService.getSignupDAO().find(SignupOrganisation.class, (Integer)adminForm.get("signupOrganisationId"));
                    } else {
                        signup = new SignupOrganisation();
                        signup.setCreateDate(new Date());
                    }
                    signup.setAddToLessons((Boolean)adminForm.get("addToLessons"));
                    signup.setAddAsStaff((Boolean)adminForm.get("addAsStaff"));
                    signup.setAddWithAuthor((Boolean)adminForm.get("addWithAuthor"));
                    signup.setAddWithMonitor((Boolean)adminForm.get("addWithMonitor"));
                    signup.setDisabled((Boolean)adminForm.get("disabled"));
                    signup.setOrganisation((Organisation)signupService.getSignupDAO().find(Organisation.class, (Integer)adminForm.get("organisationId")));
                    signup.setCourseKey(adminForm.getString("courseKey"));
                    signup.setBlurb(adminForm.getString("blurb"));
                    signup.setContext(adminForm.getString("context"));
                    signupService.getSignupDAO().insertOrUpdate(signup);
                    return mapping.findForward("admin");
                }
            }
            adminForm.set("blurb", (Object)"Register your LAMS account for this group using the form below.");
        }
        List organisations = signupService.getSignupDAO().getOrganisationCandidates();
        request.setAttribute("organisations", (Object)organisations);
        return mapping.findForward("admin-add");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer soid = WebUtil.readIntParam((HttpServletRequest)request, (String)"soid");
        if (soid != null && soid > 0) {
            signupService.getSignupDAO().deleteById(SignupOrganisation.class, soid);
        }
        return mapping.findForward("admin");
    }
}

