/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.signup.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.signup.dao.SignupDAO;
import org.lamsfoundation.lams.tool.signup.model.SignupOrganisation;
import org.lamsfoundation.lams.tool.signup.model.SignupUser;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class SignupService {
    private SignupDAO signupDAO;
    private IUserManagementService userManagementService;
    private ILessonService lessonService;

    public SignupDAO getSignupDAO() {
        return this.signupDAO;
    }

    public void setSignupDAO(SignupDAO signupDAO) {
        this.signupDAO = signupDAO;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public AuthenticationMethod getAuthenticationMethod(Integer id) {
        return (AuthenticationMethod)this.signupDAO.find(AuthenticationMethod.class, id);
    }

    public SupportedLocale getDefaultLocale() {
        String localeName = Configuration.get((String)ConfigurationKeys.SERVER_LANGUAGE);
        String langIsoCode = "en";
        String countryIsoCode = "AU";
        if (StringUtils.isNotBlank((String)localeName) && localeName.length() > 2) {
            langIsoCode = localeName.substring(0, 2);
            countryIsoCode = localeName.substring(3);
        }
        SupportedLocale locale = null;
        locale = this.getSupportedLocaleOrNull(langIsoCode, countryIsoCode);
        if (locale == null) {
            locale = this.getSupportedLocaleOrNull("en", "AU");
        }
        return locale;
    }

    private SupportedLocale getSupportedLocaleOrNull(String langIsoCode, String countryIsoCode) {
        SupportedLocale locale = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)countryIsoCode)) {
            properties.put("countryIsoCode", countryIsoCode.trim());
        }
        if (StringUtils.isNotBlank((String)langIsoCode)) {
            properties.put("languageIsoCode", langIsoCode.trim());
        }
        if (properties.isEmpty()) {
            return null;
        }
        List list = this.signupDAO.findByProperties(SupportedLocale.class, properties);
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            locale = (SupportedLocale)list.get(0);
        } else {
            locale = null;
        }
        return locale;
    }

    public void signupUser(User user, String context) {
        user.setFlashTheme(this.userManagementService.getDefaultFlashTheme());
        user.setHtmlTheme(this.userManagementService.getDefaultHtmlTheme());
        user.setDisabledFlag(Boolean.valueOf(false));
        user.setAuthenticationMethod(this.getAuthenticationMethod(AuthenticationMethod.DB));
        user.setLocale(this.getDefaultLocale());
        user.setCreateDate(new Date());
        user.setEnableFlash(Boolean.valueOf(true));
        this.signupDAO.insert(user);
        SignupOrganisation signup = this.signupDAO.getSignupOrganisation(context);
        ArrayList<String> rolesList = new ArrayList<String>();
        rolesList.add(Role.ROLE_LEARNER.toString());
        if (signup.getAddAsStaff().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithAuthor().booleanValue()) {
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithMonitor().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
        }
        this.userManagementService.setRolesForUserOrganisation(user, signup.getOrganisation().getOrganisationId(), rolesList);
        if (signup.getAddToLessons().booleanValue()) {
            user = this.userManagementService.getUserByLogin(user.getLogin());
            Set lessonSet = signup.getOrganisation().getLessons();
            for (Lesson lesson : lessonSet) {
                this.lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                if (!signup.getAddAsStaff().booleanValue()) continue;
                this.lessonService.addStaffMember(lesson.getLessonId(), user.getUserId());
            }
        }
        SignupUser sUser = new SignupUser();
        sUser.setOrganisation(signup.getOrganisation());
        sUser.setUser(user);
        sUser.setSignupDate(new Date());
        this.signupDAO.insert(sUser);
    }
}

