/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableRectValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.parser.DefaultNumberListHandler;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGRect;

public class SVGOMAnimatedRect
extends AbstractSVGAnimatedValue
implements SVGAnimatedRect {
    protected BaseSVGRect baseVal;
    protected AnimSVGRect animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedRect(AbstractElement elt, String ns, String ln, String def) {
        super(elt, ns, ln);
        this.defaultValue = def;
    }

    public SVGRect getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGRect();
        }
        return this.baseVal;
    }

    public SVGRect getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGRect();
        }
        return this.animVal;
    }

    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableRectValue animRect = (AnimatableRectValue)val;
            if (this.animVal == null) {
                this.animVal = new AnimSVGRect();
            }
            this.animVal.setAnimatedValue(animRect.getX(), animRect.getY(), animRect.getWidth(), animRect.getHeight());
        }
        this.fireAnimatedAttributeListeners();
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        SVGRect r = this.getBaseVal();
        return new AnimatableRectValue(target, r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGRect
    extends SVGOMRect {
        protected AnimSVGRect() {
        }

        public float getX() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getX();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getX();
        }

        public float getY() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getY();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getY();
        }

        public float getWidth() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getWidth();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getWidth();
        }

        public float getHeight() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getHeight();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getHeight();
        }

        public void setX(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setY(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setWidth(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setHeight(float value) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        protected void setAnimatedValue(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    protected class BaseSVGRect
    extends SVGOMRect {
        protected boolean valid;

        protected BaseSVGRect() {
        }

        public void invalidate() {
            this.valid = false;
        }

        protected void reset() {
            try {
                SVGOMAnimatedRect.this.changing = true;
                SVGOMAnimatedRect.this.element.setAttributeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName, Float.toString(this.x) + ' ' + this.y + ' ' + this.w + ' ' + this.h);
                Object var2_1 = null;
                SVGOMAnimatedRect.this.changing = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                SVGOMAnimatedRect.this.changing = false;
                throw throwable;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            Attr attr = SVGOMAnimatedRect.this.element.getAttributeNodeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName);
            String s = attr == null ? SVGOMAnimatedRect.this.defaultValue : attr.getValue();
            float[] numbers = new float[4];
            NumberListParser p = new NumberListParser();
            p.setNumberListHandler(new DefaultNumberListHandler(this, s, numbers){
                protected int count;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ float[] val$numbers;
                private final /* synthetic */ BaseSVGRect this$1;
                {
                    this.this$1 = this$1;
                    this.val$s = val$s;
                    this.val$numbers = val$numbers;
                }

                public void endNumberList() {
                    if (this.count != 4) {
                        throw new LiveAttributeException(BaseSVGRect.access$000((BaseSVGRect)this.this$1).element, BaseSVGRect.access$000((BaseSVGRect)this.this$1).localName, 1, this.val$s);
                    }
                }

                public void numberValue(float v) throws ParseException {
                    if (this.count < 4) {
                        this.val$numbers[this.count] = v;
                    }
                    if (v < 0.0f && (this.count == 2 || this.count == 3)) {
                        throw new LiveAttributeException(BaseSVGRect.access$000((BaseSVGRect)this.this$1).element, BaseSVGRect.access$000((BaseSVGRect)this.this$1).localName, 1, this.val$s);
                    }
                    ++this.count;
                }
            });
            p.parse(s);
            this.x = numbers[0];
            this.y = numbers[1];
            this.w = numbers[2];
            this.h = numbers[3];
            this.valid = true;
        }

        public float getX() {
            this.revalidate();
            return this.x;
        }

        public void setX(float x) throws DOMException {
            this.x = x;
            this.reset();
        }

        public float getY() {
            this.revalidate();
            return this.y;
        }

        public void setY(float y) throws DOMException {
            this.y = y;
            this.reset();
        }

        public float getWidth() {
            this.revalidate();
            return this.w;
        }

        public void setWidth(float width) throws DOMException {
            this.w = width;
            this.reset();
        }

        public float getHeight() {
            this.revalidate();
            return this.h;
        }

        public void setHeight(float height) throws DOMException {
            this.h = height;
            this.reset();
        }

        static /* synthetic */ SVGOMAnimatedRect access$000(BaseSVGRect x0) {
            return x0.SVGOMAnimatedRect.this;
        }
    }
}

