/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterLearnerForm.java,v 1.9 2006/09/19 06:37:23 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.web;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

import javax.servlet.http.HttpServletRequest;



/**
 * Creation Date: 19-05-05
 *  
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:form name="TwitterLearnerTwitterForm" type="org.lamsfoundation.lams.tool.twitter.web.TwitterLearnerTwitterForm"
 *
 * ----------------XDoclet Tags--------------------
 */

public class TwitterLearnerTwitterForm extends ActionForm{
    
    private static final long serialVersionUID = -669035956406254875L;

    static Logger logger = Logger.getLogger(TwitterLearnerForm.class.getName());
    
    private String title;

    private String twitterUsername;

    private String twitterPassword;
    
    private String toolSessionID;
    
    private String mode;
    
    /**
     * @return Returns the title.
     */
    public String getTitle() {
        return title;
    }
    /**
     * @param title The method to set.
     */
    public void setTitle(String title) {
        this.title = title;
    }
    
    /**
     * @return Returns the twitter username.
     */
    public String getTwitterUsername() {
        return twitterUsername;
    }
    /**
     * @param twitterUsername The method to set.
     */
    public void setTwitterUsername(String twitterUsername) {
        this.twitterUsername = twitterUsername;
    }
    
    /**
     * @return Returns the twitter password.
     */
    public String getTwitterPassword() {
        return twitterPassword;
    }
    /**
     * @param twitterPassword The method to set.
     */
    public void setTwitterPassword(String twitterPassword) {
        this.twitterPassword = twitterPassword;
    }
    
    /**
     * @return Returns the toolSessionID.
     */
    public String getToolSessionID() {
        return toolSessionID;
    }
    /**
     * @param toolSessionID The method to set.
     */
    public void setToolSessionID(String toolSessionID) {
        this.toolSessionID = toolSessionID;
    }
    
    /**
     * @return Returns the mode.
     */
    public String getMode() {
        return mode;
    }
    /**
     * @param mode The method to set.
     */
    public void setMode(String mode) {
        this.mode = mode;
    }
    
    public void reset()
    {
	this.twitterUsername = null;
	this.twitterPassword = null;
	this.toolSessionID = null;
	this.mode = null;

    }
    
    public void copyValuesIntoForm(String title)
    {
	this.title = title;	
    }
    
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
	boolean usernameEntered = false;
	boolean passwordEntered = false;
	
	ActionErrors errors = new ActionErrors();
	
	if(twitterUsername != null && twitterUsername != "") usernameEntered = true;
	if(twitterPassword != null && twitterPassword != "") passwordEntered = true;
	
	if(!usernameEntered){
	    errors.add(null, new ActionMessage("error.twitter.username.missing"));
	}
	if(!passwordEntered){
	    errors.add(null, new ActionMessage("error.twitter.password.missing"));
	}
	return errors;
    }
}
