/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 * USA
 *
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $Id: ReflectionDTO.java,v 1.1 2006/09/19 06:37:24 jliew Exp $ */
package org.lamsfoundation.lams.tool.twitter.dto;

import org.lamsfoundation.lams.notebook.model.NotebookEntry;

/**
 * @author jliew
 *
 */
public class ReflectionDTO {

	private Long userId;
	private String username;
	private String fullName;
	private String entry;
	private Long externalId;
	
	public ReflectionDTO(NotebookEntry twitterEntry) {
		this.entry = twitterEntry.getEntry();
	}
	
	public Long getUserId() {
		return userId;
	}
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
	
	public String getUsername() {
		return username;
	}
	
	public void setUsername(String username) {
		this.username = username;
	}
	
	public String getFullName() {
		return fullName;
	}
	
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	
	public String getEntry() {
		return entry;
	}
	
	public void setEntry(String entry) {
		this.entry = entry;
	}
	
	public Long getExternalId() {
		return externalId;
	}
	
	public void setExternalId(Long externalId) {
		this.externalId = externalId;
	}
	
}
