/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestTwitterAttachmentDAO.java,v 1.6 2006/09/17 06:26:25 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import org.lamsfoundation.lams.tool.twitter.TwitterDataAccessTestCase;
import org.lamsfoundation.lams.tool.twitter.dao.hibernate.TwitterAttachmentDAO;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import java.util.List;

/**
 * @author mtruong
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TestTwitterAttachmentDAO extends TwitterDataAccessTestCase {

  /*  private TwitterAttachmentDAO attachmentDao;
    private TwitterContentDAO contentDao; 
    private TwitterAttachment twitterAttachment = null;
    private TwitterContent twitterContent = null; */
  
   
    public TestTwitterAttachmentDAO(String name)
    {
        super(name);
    }
    

    /**
     * @see TwitterDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	     super.setUp();
	     
	     initAllData();
	     initTwitterAttachmentData();
	 }
	 
	 /**
	  * @see TwitterDataAccessTestCase#tearDown()
	  */
	 protected void tearDown() throws Exception {
	    
	     cleanTwitterContentData(TEST_NB_ID);
	 }
	 
	 
	
	 public void testRetrieveAttachment()
	 {
	    
	    //test retrieveAttachmentByUuid
	    twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	    assertAttachmentData(twitterAttachment);
	     
	     /* test getAttachmentsFromContent which will return a list of attachment ids, which we can use in the next method call to
	     retrieveAttachment which takes in the attachmentId as the parameter. */
	     List attachmentIds = attachmentDAO.getAttachmentIdsFromContent(twitterDAO.findTwitterContentById(TEST_NB_ID));
	     
	     //test retrieveAttachment (by attachmentId, which was retrieved from the previous method)
	     twitterAttachment = attachmentDAO.retrieveAttachment((Long)attachmentIds.get(0));
	     assertAttachmentData(twitterAttachment);
	     
	     //test retrieveAttachment (by filename as the parameter
	     twitterAttachment = attachmentDAO.retrieveAttachmentByFilename(TEST_FILENAME);
	     assertAttachmentData(twitterAttachment);
	 }
	 

	 
	 public void testSaveAttachment()
	 {
	     String newFilename = "new filename";
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     twitterAttachment.setFilename(newFilename);
	     
	     attachmentDAO.saveAttachment(twitterAttachment);
	     
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertEquals("Validating the new filename", twitterAttachment.getFilename(), newFilename);
	 }
	
	 public void testRemoveAttachment()
	 {
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     //remove any associations
	     twitterContent = twitterDAO.findTwitterContentById(TEST_NB_ID);
	     twitterContent.getTwitterAttachments().remove(twitterAttachment);
	     
	     attachmentDAO.removeAttachment(twitterAttachment);
	     
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNull(twitterAttachment);
	     
	 } 
	 
	 public void testRemoveAttachmentByUuid()
	 {
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNotNull(twitterAttachment);
	     
	     //	   remove any associations
	     twitterContent = twitterDAO.findTwitterContentById(TEST_NB_ID);
	     twitterContent.getTwitterAttachments().remove(twitterAttachment);	
	     
	     attachmentDAO.removeAttachment(TEST_UUID);
	     
	     twitterAttachment = attachmentDAO.retrieveAttachmentByUuid(TEST_UUID);
	     assertNull(twitterAttachment);
	     
	 } 
	 
	
	
	 
	 
}
