/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterUserDAO.java,v 1.9 2006/09/19 06:37:25 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;

/**
 * @author mtruong
 * <p>Hibernate implementation for database access to Twitter users (learners) for the twitter tool.</p>
 */
public class TwitterUserDAO extends HibernateDaoSupport implements ITwitterUserDAO {
    
	private static final String FIND_NB_USER = "from " + TwitterUser.class.getName() + " as twitter where twitter.userId=?";
	
	private static final String FIND_NB_USER_BY_SESSION = "from " + TwitterUser.class.getName() + " as twitter where twitter.userId=? and twitter.twitterSession.twitterSessionId=?";
	
    private static final String COUNT_USERS_IN_SESSION = "select nu.userId from TwitterUser nu where nu.twitterSession= :twitterSession";
   
  
	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#getTwitterUserByID(java.lang.Long) */
	public TwitterUser getTwitterUser(Long userId, Long sessionId)
	{
	    String query = "from TwitterUser user where user.userId=? and user.twitterSession.twitterSessionId=?";
	    Object[] values = new Object[2];
	    values[0] = userId;
	    values[1] = sessionId;
	    List users = getHibernateTemplate().find(query,values);
		if(users!=null && users.size() == 0)
		{			
			return null;
		}
		else
		{
			return (TwitterUser)users.get(0);
		}
	}
	
	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#getTwitterUserBySession(java.lang.Long, java.lang.Long)*/
	public TwitterUser getTwitterUserBySession(Long userId, Long sessionId)
	{	
		List usersReturned = getSession().createQuery(FIND_NB_USER_BY_SESSION)
			.setLong(0,userId.longValue())
			.setLong(1, sessionId.longValue())
			.list();
	
		if(usersReturned != null && usersReturned.size() > 0){
			TwitterUser twitter = (TwitterUser) usersReturned.get(0);
			return twitter;
		}
		else
			return null;

	}

	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#saveTwitterUser(org.lamsfoundation.lams.tool.twitter.TwitterUser) */
	public void saveTwitterUser(TwitterUser twitterUser)
    {
    	this.getHibernateTemplate().save(twitterUser);
    }
	
	/** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#updateTwitterUser(org.lamsfoundation.lams.tool.twitter.TwitterUser) */
    public void updateTwitterUser(TwitterUser twitterUser)
    {
    	this.getHibernateTemplate().update(twitterUser);
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#removeTwitterUser(java.lang.Long) */
    public void removeTwitterUser(Long userId)
    {
		if ( userId != null) {
			//String query = "from org.lamsfoundation.lams.tool.twitter.TwitterContent as twitter where twitter.twitterContentId=?";
			List list = getSession().createQuery(FIND_NB_USER)
				.setLong(0,userId.longValue())
				.list();
			
			if(list != null && list.size() > 0){
				TwitterUser twitter = (TwitterUser) list.get(0);
				this.getSession().setFlushMode(FlushMode.AUTO);
				this.getHibernateTemplate().delete(twitter);
				this.getHibernateTemplate().flush();
			}
		}
      
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#removeTwitterUser(org.lamsfoundation.lams.tool.twitter.TwitterUser) */
    public void removeTwitterUser(TwitterUser twitterUser)
    {
       // this.getHibernateTemplate().delete(twitterUser);
    	removeTwitterUser(twitterUser.getUserId());
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO#getNumberOfUsers((org.lamsfoundation.lams.tool.twitter.TwitterSession) */
    public int getNumberOfUsers(TwitterSession twitterSession)
    {
        return (getHibernateTemplate().findByNamedParam(COUNT_USERS_IN_SESSION,
	            "twitterSession",
				twitterSession)).size();
    }
    
    public List getTwitterUsersBySession(Long sessionId) {
    	String query = "from TwitterUser user where user.twitterSession.twitterSessionId=?";
	    return getHibernateTemplate().find(query,sessionId);
    }
}
