/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterAttachmentDAO.java,v 1.8 2006/09/17 06:26:26 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
/**
 * @author mtruong
 *
 * <p>Hibernate implementation for database access of twitter attachment,
 * which are generally the uploads, updates and removal of online/offline
 * instruction files </p>
 */
public class TwitterAttachmentDAO extends HibernateDaoSupport implements ITwitterAttachmentDAO {
	
	private static final String FIND_NB_ATTACHMENT_BY_UUID = "from " + TwitterAttachment.class.getName() + " as twitter where twitter.uuid=?";
	private static final String FIND_NB_ATTACHMENT_BY_FILENAME = "from " + TwitterAttachment.class.getName() + " as twitter where twitter.filename=?";
	private static final String GET_ATTACHMENT_FROM_CONTENT = "select twitter.attachmentId from " + TwitterAttachment.class.getName() + " as twitter where twitter.twitterContent= :twitterContent";
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#retrieveAttachment(java.lang.Long) */
    public TwitterAttachment retrieveAttachment(Long attachmentId)
    {
        return (TwitterAttachment)this.getHibernateTemplate().get(TwitterAttachment.class, attachmentId);
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#retrieveAttachmentByUuid(java.lang.Long) */
    public TwitterAttachment retrieveAttachmentByUuid(Long uuid)
    {
        List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID)
		.setLong(0,uuid.longValue())
		.list();

		if(attachments != null && attachments.size() > 0){
			TwitterAttachment twitter = (TwitterAttachment) attachments.get(0);
			return twitter;
		}
		else
			return null;
	    	
    	
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#retrieveAttachmentByFilename(java.lang.String) */
    public TwitterAttachment retrieveAttachmentByFilename(String filename)
    {
    	List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_FILENAME)
		.setString(0, filename)
		.list();

		if(attachments != null && attachments.size() > 0){
			TwitterAttachment twitter = (TwitterAttachment) attachments.get(0);
			return twitter;
		}
		else
			return null;
    }
    
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#getAttachmentIdsFromContent(org.lamsfoundation.lams.tool.twitter.TwitterContent) */
    public List getAttachmentIdsFromContent(TwitterContent twitterContent)
    {
        return (getHibernateTemplate().findByNamedParam(GET_ATTACHMENT_FROM_CONTENT,
	            "twitterContent",
				twitterContent));
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#saveAttachment(org.lamsfoundation.lams.tool.twitter.TwitterContent) */
    public void saveAttachment(TwitterAttachment attachment)
    {
        this.getHibernateTemplate().saveOrUpdate(attachment);
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#removeAttachment(org.lamsfoundation.lams.tool.twitter.TwitterContent) */
    public void removeAttachment(TwitterAttachment attachment)
    {
    	//this.getHibernateTemplate().delete(attachment);
    	removeAttachment(attachment.getUuid());
    }
    
    /** @see org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO#removeAttachment(java.lang.Long) */
    public void removeAttachment(Long uuid)
    {
        //this.getHibernateTemplate().delete(retrieveAttachmentByUuid(uuid));
    	List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID)
		.setLong(0,uuid.longValue())
		.list();

		if(attachments != null && attachments.size() > 0){
			TwitterAttachment twitter = (TwitterAttachment) attachments.get(0);
			this.getSession().setFlushMode(FlushMode.AUTO);
			this.getHibernateTemplate().delete(twitter);
			this.getHibernateTemplate().flush();
		}
    	
    }
}
