/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: ITwitterUserDAO.java,v 1.8 2006/09/19 06:37:24 jliew Exp $$ */
package org.lamsfoundation.lams.tool.twitter.dao;

import java.util.List;

import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;

/**
 * @author mtruong
 * 
 * <p>Interface for the TwitterSession DAO, defines methods needed to access/modify
 * twitter users (learners of the twitter activity) </p>
 */
public interface ITwitterUserDAO {
    
   
    /**
	 * <p> Return the persistent instance of a TwitterUser
	 * with the given user id <code>userId</code>,
	 * returns null if not found.</p>
	 * 
	 * @param userId The id of a TwitterUser
	 * @return the persistent instance of a TwitterUser or null if not found.
	 */
    public TwitterUser getTwitterUser(Long userId, Long toolSessionId);
    
    /**
	 * <p> Return the persistent instance of a TwitterUser
	 * who has the user id <code>userId</code> and tool session id
	 * <code>sessionId</code>
	 * returns null if not found.</p>
	 * 
	 * @param userId. The id of the learner
	 * @param sessionId. The tool session id to which this user belongs to.
	 * @return the persistent instance of a TwitterUser or null if not found.
	 */
    public TwitterUser getTwitterUserBySession(Long userId, Long sessionId);
    
    /**
	 * <p>Persist the given persistent instance of TwitterUser.</p>
	 * 
	 * @param twitterUser The instance of TwitterUser to persist.
	 */
    public void saveTwitterUser(TwitterUser twitterUser);
    
    /**
     * <p>Update the given persistent instance of TwitterUser.</p>
     * 
     * @param twitterUser The instance of TwitterUser to persist.
     */
    public void updateTwitterUser(TwitterUser twitterUser);
    
    /**
     * <p>Delete the given instance of TwitterUser</p>
     * 
     * @param twitterUser The instance of TwitterUser to delete. 
     */
    public void removeTwitterUser(TwitterUser twitterUser);
    
    /**
     * <p>Delete the given instance of TwitterUser with the
     * given user id <code>userId</code>
     * 
     * @param userId The twitter user id.
     */
    public void removeTwitterUser(Long userId);
    
    /**
     * Returns the number of users that are in this particular
     * session.
     * 
     * @param twitterSession
     * @return the number of users that are in this session
     */
    public int getNumberOfUsers(TwitterSession twitterSession);
   
    public List getTwitterUsersBySession(Long sessionId);
}
