/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TwitterUserTweet.java,v 1.19 2006/10/10 07:47:02 mseaton Exp $$ */
package org.lamsfoundation.lams.tool.twitter;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>Persistent twitter object/bean that defines a user tweet (Twitter) for the twitter tool.
 * Provides accessors and mutators to get/set twitter attributes</p>
 * @hibernate.class table="tl_fptwit10_user_tweet"
 * @author fpenar
 */
public class TwitterUserTweet implements Serializable {
	
	/** identifier field */
    	private Long tweetId;
	
        /** persistent field. Cannot be null */
        private TwitterUser twitterUser;
        
        /** persistent field. Cannot be null */
        private TwitterContent twitterContent;
    	
	/** nullable persistent field */
	private String tweet;
	
	/** nullable persistent field */
	private String twitterUsername;
	
	/** nullable persistent field */
	private Date creationDate;
	
	/** nullable persistent field */
	private String twitterPicture;
	
	/** default constructor */
	public TwitterUserTweet(){}
	
	/** full constructor */
	public TwitterUserTweet(	TwitterUser twitterUser,
						TwitterContent twitterContent,
						String tweet,
						String twitterUsername,
						Date creationDate,
						String twitterPicture)
	{
		this.twitterUser = twitterUser;
		this.twitterContent = twitterContent;
		this.tweet = tweet;
		this.twitterUsername = twitterUsername;
		this.creationDate = creationDate;
		this.twitterPicture = twitterPicture;

	}
	
    
	/**
	* @hibernate.property
	* column="tweet"
	* length="140"
	*/
	
	public String getTweet() {
	    return tweet;
	}

	public void setTweet(String tweet) {
	    this.tweet = tweet;
	}
	
	/**
	* @hibernate.property
	* column="twitter_username"
	* length="255"
	*/
	
	public String getTwitterUsername() {
	    return twitterUsername;
	}

	public void setTwitterUsername(String twitterUsername) {
	    this.twitterUsername = twitterUsername;
	}
	
	/**
	* @hibernate.property
	* column="creation_date"
	*/
	
	public Date getCreationDate() {
	    return creationDate;
	}

	public void setCreationDate(Date creationDate) {
	    this.creationDate = creationDate;
	}
	
	/**
	* @hibernate.property
	* column="twitter_picture"
	* length="511"
	*/	
	public String getTwitterPicture() {
	    return twitterPicture;
	}
	
	public void setTwitterPicture(String twitterPicture) {
	    this.twitterPicture = twitterPicture;
	}
	
	/**
	* @hibernate.many-to-one 
	* not-null="true" 
	*
	* @hibernate.column 
	* name="twitter_content_uid"
	*
	* @return Returns the twitterContent.
	*/
	public TwitterContent getTwitterContent() {
	    return twitterContent;
	}
	/**
	* @param twitterContent The twitterContent to set.
	*/
	public void setTwitterContent(TwitterContent twitterContent) {
	    this.twitterContent = twitterContent;
	}
	
	/**
	* @hibernate.many-to-one 
	* not-null="true" 
	*
	* @hibernate.column 
	* name="twitter_user_uid"
	*
	* @return Returns the twitterUser.
	*/
	public TwitterUser getTwitterUser() {
	    return twitterUser;
	}
	/**
	* @param twitterContent The twitterContent to set.
	*/
	public void setTwitterUser(TwitterUser twitterUser) {
	    this.twitterUser = twitterUser;
	}



	/**
     	* @hibernate.id 
	* generator-class="native" 
	* type="java.lang.Long" 
	* column="tweet_id"
	* 
	* @return Returns the tweetId.
	*/
	public Long getTweetId() {
	    return tweetId;
	}
    
	/**
     	@param tweetId The tweetId to set.
	 */
	public void setTweetId(Long tweetId) {
	    this.tweetId = tweetId;
	}
}
