/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class UpdateApplicationXmlTask
implements Task {
    protected String lamsEarPath;
    protected String webUri;
    protected String module;
    protected String contextRoot;
    private String applicationXmlPath;

    public void setLamsEarPath(String lamsEarPath) {
        this.lamsEarPath = lamsEarPath;
        this.applicationXmlPath = lamsEarPath + "/META-INF/application.xml";
    }

    public void setWebUri(String webUri) {
        this.webUri = webUri;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void execute() throws DeployException {
        Document doc = this.parseApplicationXml();
        this.updateApplicationXml(doc);
        this.writeApplicationXml(doc);
    }

    protected void writeApplicationXml(Document doc) throws DeployException {
        System.out.println("Writing out doc " + doc);
        try {
            doc.normalize();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.applicationXmlPath);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerException tex) {
            throw new DeployException("Error writing out modified application xml", tex);
        }
    }

    protected Element findWebElement(Document doc) throws DeployException {
        NodeList webNodesList = doc.getElementsByTagName("web");
        if (webNodesList == null || webNodesList.getLength() < 1) {
            throw new DeployException("LAMS Application XML does not have a web element");
        }
        if (webNodesList.getLength() > 1) {
            throw new DeployException("LAMS Application XML should only have one web element");
        }
        return (Element)webNodesList.item(0);
    }

    protected Document parseApplicationXml() throws DeployException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(this.applicationXmlPath);
        }
        catch (ParserConfigurationException pex) {
            throw new DeployException("Could not configure parser", pex);
        }
        catch (SAXException saxex) {
            throw new DeployException("Error parsing application xml", saxex);
        }
        catch (IOException ioex) {
            throw new DeployException("Error reading application xml", ioex);
        }
    }

    protected Element findElementWithMatchingText(String text, NodeList nodeList) throws DeployException {
        Element matchedElement = null;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            NodeList children;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(node instanceof Element) || (children = node.getChildNodes()) == null || children.getLength() <= 0 || !(children.item(0) instanceof Text) || !children.item(0).getNodeValue().equals(text)) continue;
            matchedElement = (Element)node;
            break;
        }
        return matchedElement;
    }

    protected Element findElementWithWebURI(Document doc) {
        NodeList webUriNodeList = doc.getElementsByTagName("web-uri");
        Element matchingWebUriElement = this.findElementWithMatchingText(this.webUri, webUriNodeList);
        if (matchingWebUriElement != null) {
            return (Element)matchingWebUriElement.getParentNode().getParentNode();
        }
        return null;
    }

    protected Element findElementWithModule(Document doc) {
        NodeList moduleNodeList = doc.getElementsByTagName("java");
        Element matchingModuleElement = this.findElementWithMatchingText(this.module, moduleNodeList);
        if (matchingModuleElement != null) {
            return (Element)matchingModuleElement.getParentNode();
        }
        return null;
    }

    protected abstract void updateApplicationXml(Document var1) throws DeployException;
}

