/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DeployException;

public class ScriptRunner {
    public static final String STATEMENT_DELIMITER = ";";
    public static final String HASH_COMMENT_PATTERN = "#.*";
    public static final String DASH_COMMENT_PATTERN = "\\-{2,}.*";
    public static final String LINE_BREAK_PATTERN = "\\r\\n|\\n|\\r|\\u0085|\\u2028|\\u2029";
    public static final String LARGE_WHITE_SPACE_PATTERN = "\\s{2,}";
    protected Connection conn;
    protected String sqlScript;

    public ScriptRunner(String sqlScript, Connection conn) {
        this.conn = conn;
        this.sqlScript = sqlScript;
    }

    public void run() throws DeployException {
        String[] statements = this.parseScript(this.sqlScript);
        this.executeStatements(statements, this.conn);
    }

    protected String[] parseScript(String script) throws DeployException {
        script = script.replaceAll(HASH_COMMENT_PATTERN, "");
        script = script.replaceAll(DASH_COMMENT_PATTERN, "");
        script = script.replaceAll(LINE_BREAK_PATTERN, "");
        script = script.replaceAll(LARGE_WHITE_SPACE_PATTERN, " ");
        return script.split(STATEMENT_DELIMITER);
    }

    protected void executeStatements(String[] statements, Connection newConn) throws DeployException {
        Statement stmt = null;
        try {
            stmt = newConn.createStatement();
            int length = statements.length;
            for (int i = 0; i < length; ++i) {
                stmt.addBatch(statements[i]);
            }
            stmt.executeBatch();
        }
        catch (SQLException sqlex) {
            throw new DeployException("Could not execute statements", sqlex);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }
}

