/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.web.TwitterPedagogicalPlannerForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerAction;

public class TwitterPedagogicalPlannerAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(PedagogicalPlannerAction.class);
    public ITwitterService twitterService;

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.twitterService == null) {
            this.twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        }
        return this.initPedagogicalPlannerForm(mapping, form, request, response);
    }

    public ActionForward initPedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TwitterPedagogicalPlannerForm plannerForm = (TwitterPedagogicalPlannerForm)form;
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        TwitterContent twitter = this.getTwitterService().retrieveTwitter(toolContentID);
        String command = WebUtil.readStrParam((HttpServletRequest)request, (String)"command", (boolean)true);
        if (command == null) {
            plannerForm.fillForm(twitter);
            String contentFolderId = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
            plannerForm.setContentFolderID(contentFolderId);
            return mapping.findForward("success");
        }
        try {
            String onlineInstructions = twitter.getOnlineInstructions();
            response.setContentType("text/html;charset=utf-8");
            PrintWriter writer = response.getWriter();
            if ("checkEditingAdvice".equals(command)) {
                Integer activityIndex = WebUtil.readIntParam((HttpServletRequest)request, (String)"activityIndex");
                String responseText = (StringUtils.isEmpty((String)twitter.getOnlineInstructions()) ? "NO" : "OK") + '&' + activityIndex;
                writer.print(responseText);
            } else if ("getEditingAdvice".equals(command)) {
                writer.print(onlineInstructions);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public ActionForward saveOrUpdatePedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TwitterPedagogicalPlannerForm plannerForm = (TwitterPedagogicalPlannerForm)form;
        ActionMessages errors = plannerForm.validate();
        if (errors.isEmpty()) {
            String content = plannerForm.getContent();
            Long toolContentID = plannerForm.getToolContentID();
            TwitterContent twitter = this.getTwitterService().retrieveTwitter(toolContentID);
            twitter.setContent(content);
            this.getTwitterService().saveTwitter(twitter);
        } else {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("success");
    }

    private ITwitterService getTwitterService() {
        if (this.twitterService == null) {
            this.twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        }
        return this.twitterService;
    }
}

