/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.service;

import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterAttachment;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterSession;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterAttachmentDAO;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterContentDAO;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterSessionDAO;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserDAO;
import org.lamsfoundation.lams.tool.twitter.dao.ITwitterUserTweetDAO;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.dao.DataAccessException;

public class TwitterServicePOJO
implements ITwitterService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    private TwitterContent twitterContent;
    private ITwitterContentDAO twitterContentDAO = null;
    private TwitterSession twitterSession;
    private ITwitterSessionDAO twitterSessionDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private TwitterUser twitterUser;
    private ITwitterUserDAO twitterUserDAO = null;
    private TwitterUserTweet[] twitterUserTweets;
    private ITwitterUserTweetDAO twitterUserTweetDAO = null;
    private ITwitterAttachmentDAO twitterAttachmentDAO = null;
    private IToolContentHandler twitterToolContentHandler = null;
    private IExportToolContentService exportContentService;
    private static Logger log = Logger.getLogger(TwitterServicePOJO.class);
    private ICoreNotebookService coreNotebookService;

    @Override
    public TwitterContent retrieveTwitter(Long twitterContentId) throws TwitterApplicationException {
        if (twitterContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterContent = this.twitterContentDAO.findTwitterContentById(twitterContentId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter content: " + e.getMessage(), e);
        }
        return this.twitterContent;
    }

    @Override
    public TwitterContent retrieveTwitterBySessionID(Long twitterSessionId) {
        if (twitterSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterContent = this.twitterContentDAO.getTwitterContentBySession(twitterSessionId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter content: " + e.getMessage(), e);
        }
        return this.twitterContent;
    }

    @Override
    public void saveTwitter(TwitterContent twitterContent) {
        try {
            if (twitterContent.getUid() == null) {
                this.twitterContentDAO.saveTwitterContent(twitterContent);
            } else {
                this.twitterContentDAO.updateTwitterContent(twitterContent);
            }
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to save the twitter content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeTwitterSessionsFromContent(TwitterContent twitterContent) {
        try {
            twitterContent.getTwitterSessions().clear();
            this.twitterContentDAO.removeTwitterSessions(twitterContent);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove the sessions associated with this twitter content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeTwitter(Long twitterContentId) {
        if (twitterContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterContentDAO.removeTwitter(twitterContentId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove this twitter content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeTwitter(TwitterContent twitterContent) {
        try {
            this.twitterContentDAO.removeTwitter(twitterContent);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove this twitter content object: " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterSession retrieveTwitterSession(Long twitterSessionId) {
        if (twitterSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterSession = this.twitterSessionDAO.findTwitterSessionById(twitterSessionId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter session object: " + e.getMessage(), e);
        }
        return this.twitterSession;
    }

    @Override
    public void saveTwitterSession(TwitterSession twitterSession) {
        try {
            TwitterContent content = twitterSession.getTwitterContent();
            this.twitterSessionDAO.saveTwitterSession(twitterSession);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to save this twitter session: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateTwitterSession(TwitterSession twitterSession) {
        try {
            this.twitterSessionDAO.updateTwitterSession(twitterSession);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to update this twitter session: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeSession(Long twitterSessionId) {
        if (twitterSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            TwitterSession sessionToDelete = this.retrieveTwitterSession(twitterSessionId);
            TwitterContent contentReferredBySession = sessionToDelete.getTwitterContent();
            contentReferredBySession.getTwitterSessions().remove(sessionToDelete);
            this.twitterSessionDAO.removeTwitterSession(twitterSessionId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove this twitter session object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeSession(TwitterSession twitterSession) {
        try {
            TwitterContent contentReferredBySession = twitterSession.getTwitterContent();
            contentReferredBySession.getTwitterSessions().remove(twitterSession);
            this.twitterSessionDAO.removeTwitterSession(twitterSession);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove this twitter session object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeTwitterUsersFromSession(TwitterSession twitterSession) {
        try {
            twitterSession.getTwitterUsers().clear();
            this.twitterSessionDAO.removeTwitterUsers(twitterSession);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove the users associated with this twitter session instance: " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterSession retrieveTwitterSessionByUserID(Long userId) {
        if (userId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterSession = this.twitterSessionDAO.getTwitterSessionByUser(userId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrieve twitter session instance " + e.getMessage(), e);
        }
        return this.twitterSession;
    }

    @Override
    public List getSessionIdsFromContent(TwitterContent content) {
        List list = null;
        try {
            list = this.twitterSessionDAO.getSessionsFromContent(content);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to the list of session ids from content " + e.getMessage(), e);
        }
        return list;
    }

    @Override
    public TwitterUser retrieveTwitterUser(Long twitterUserId, Long twitterSessionId) {
        if (twitterUserId == null) {
            String error = "Unable to continue. The user id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterUser = this.twitterUserDAO.getTwitterUser(twitterUserId, twitterSessionId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter user: " + e.getMessage(), e);
        }
        return this.twitterUser;
    }

    @Override
    public void saveTwitterUser(TwitterUser twitterUser) {
        try {
            TwitterSession session = twitterUser.getTwitterSession();
            session.getTwitterUsers().add(twitterUser);
            this.twitterUserDAO.saveTwitterUser(twitterUser);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to save the twitter user object: " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterUser retrieveTwitterUserBySession(Long userId, Long sessionId) {
        try {
            this.twitterUser = this.twitterUserDAO.getTwitterUserBySession(userId, sessionId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrive the twitter user object: " + e.getMessage(), e);
        }
        return this.twitterUser;
    }

    @Override
    public void updateTwitterUser(TwitterUser twitterUser) {
        try {
            this.twitterUserDAO.updateTwitterUser(twitterUser);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to update the twitter user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeUser(TwitterUser twitterUser) {
        try {
            TwitterSession session = twitterUser.getTwitterSession();
            session.getTwitterUsers().remove(twitterUser);
            this.twitterUserDAO.removeTwitterUser(twitterUser);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove the twitter user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeUser(Long twitterUserId, Long toolSessionId) {
        if (twitterUserId == null) {
            String error = "Unable to continue. The user id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            TwitterUser user = this.retrieveTwitterUser(twitterUserId, toolSessionId);
            TwitterSession session = user.getTwitterSession();
            session.getTwitterUsers().remove(user);
            this.twitterUserDAO.removeTwitterUser(twitterUserId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove the twitter user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void addSession(Long twitterContentId, TwitterSession session) {
        if (twitterContentId == null || session == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterContentDAO.addTwitterSession(twitterContentId, session);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to create session: " + e.getMessage(), e);
        }
    }

    @Override
    public void addUser(Long twitterSessionId, TwitterUser user) {
        if (twitterSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterSessionDAO.addTwitterUsers(twitterSessionId, user);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to create user: " + e.getMessage(), e);
        }
    }

    @Override
    public int getNumberOfUsersInSession(TwitterSession session) {
        int numberOfUsers;
        try {
            numberOfUsers = this.twitterUserDAO.getNumberOfUsers(session);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to get the number of users in the session: " + e.getMessage(), e);
        }
        return numberOfUsers;
    }

    @Override
    public int calculateTotalNumberOfUsers(Long toolContentId) {
        if (toolContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        int totalNumberOfUsers = 0;
        try {
            this.twitterContent = this.retrieveTwitter(toolContentId);
            List listOfSessionIds = this.getSessionIdsFromContent(this.twitterContent);
            for (Long sessionId : listOfSessionIds) {
                int usersInThisSession = this.getNumberOfUsersInSession(this.retrieveTwitterSession(sessionId));
                totalNumberOfUsers += usersInThisSession;
            }
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while calculating the total number of users in tool activity " + e.getMessage(), e);
        }
        return totalNumberOfUsers;
    }

    @Override
    public List getUsersBySession(Long sessionId) {
        if (sessionId != null) {
            try {
                return this.twitterUserDAO.getTwitterUsersBySession(sessionId);
            }
            catch (DataAccessException e) {
                throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to get the list of users in the session: " + e.getMessage(), e);
            }
        }
        log.error((Object)"Unable to continue. Session id is missing");
        return null;
    }

    @Override
    public int retrieveNumberOfTweetsByUser(Long toolContentId, Long userId) {
        if (toolContentId == null) {
            String error = "Unable to continue. The content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        if (userId == null) {
            String error = "Unable to continue. The user id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        int numberOfTweets = 0;
        try {
            numberOfTweets = this.twitterUserTweetDAO.getNumberOfTweetsByUser(toolContentId, userId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter tweets: " + e.getMessage(), e);
        }
        return numberOfTweets;
    }

    @Override
    public TwitterUserTweet[] retrieveTwitterUserTweet(Long toolContentId) {
        if (toolContentId == null) {
            String error = "Unable to continue. The content id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            this.twitterUserTweets = this.twitterUserTweetDAO.getTwitterUserTweet(toolContentId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("An exception has occured when trying to retrieve twitter tweets: " + e.getMessage(), e);
        }
        return this.twitterUserTweets;
    }

    @Override
    public void saveTwitterUserTweet(TwitterUserTweet twitterUserTweet) {
        try {
            this.twitterUserTweetDAO.saveTwitterUserTweet(twitterUserTweet);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to save the twitter user tweet object: " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterUserTweet[] retrieveTwitterUserTweetByUser(Long userId, Long toolContentId) {
        try {
            this.twitterUserTweets = this.twitterUserTweetDAO.getTwitterUserTweetByUser(userId, toolContentId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrive the twitter user tweet object: " + e.getMessage(), e);
        }
        return this.twitterUserTweets;
    }

    @Override
    public TwitterAttachment retrieveAttachment(Long attachmentId) {
        if (attachmentId == null) {
            String error = "Unable to continue. The attachment id is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            return this.twitterAttachmentDAO.retrieveAttachment(attachmentId);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterAttachment retrieveAttachmentByUuid(Long uuid) {
        if (uuid == null) {
            String error = "Unable to continue. The uuid is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            return this.twitterAttachmentDAO.retrieveAttachmentByUuid(uuid);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public TwitterAttachment retrieveAttachmentByFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            String error = "Unable to continue. The filename is missing";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        try {
            return this.twitterAttachmentDAO.retrieveAttachmentByFilename(filename);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment with filename " + filename + " " + e.getMessage(), e);
        }
    }

    @Override
    public List getAttachmentIdsFromContent(TwitterContent twitterContent) {
        try {
            return this.twitterAttachmentDAO.getAttachmentIdsFromContent(twitterContent);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the list of attachment ids " + e.getMessage(), e);
        }
    }

    @Override
    public void saveAttachment(TwitterContent content, TwitterAttachment attachment) {
        try {
            content.getTwitterAttachments().add(attachment);
            attachment.setTwitterContent(content);
            this.saveTwitter(content);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to save the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public void removeAttachment(TwitterContent content, TwitterAttachment attachment) throws RepositoryCheckedException {
        try {
            attachment.setTwitterContent(null);
            content.getTwitterAttachments().remove(attachment);
            this.saveTwitter(content);
        }
        catch (DataAccessException e) {
            throw new TwitterApplicationException("EXCEPTION: An exception has occurred while trying to remove this attachment" + e.getMessage(), e);
        }
    }

    @Override
    public NodeKey uploadFile(InputStream istream, String filename, String contentType, String fileType) throws RepositoryCheckedException {
        return this.twitterToolContentHandler.uploadFile(istream, filename, contentType, fileType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to copy Twitter tool content. Missing parameter: toContentId");
        }
        if (fromContentId == null) {
            fromContentId = this.getToolDefaultContentIdBySignature("fptwit10");
        }
        TwitterContent originalTwitter = null;
        try {
            originalTwitter = this.retrieveTwitter(fromContentId);
            if (originalTwitter == null) {
                TwitterContent defaultContent = this.retrieveTwitter(this.getToolDefaultContentIdBySignature("fptwit10"));
                if (defaultContent == null) throw new ToolException("Default content is missing. Unable to copy tool content");
                TwitterContent newContent = TwitterContent.newInstance(defaultContent, toContentId, this.twitterToolContentHandler);
                this.saveTwitter(newContent);
                return;
            } else {
                TwitterContent newTwitterContent = TwitterContent.newInstance(originalTwitter, toContentId, this.twitterToolContentHandler);
                this.saveTwitter(newTwitterContent);
            }
            return;
        }
        catch (RepositoryCheckedException e) {
            log.error((Object)("Unable to copy the tool content due to a content repository error. fromContentId " + fromContentId + " toContentId " + toContentId));
            throw new ToolException((Throwable)e);
        }
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        TwitterContent twitterContent = this.getAndCheckIDandObject(toolContentId);
        twitterContent.setDefineLater(value);
        this.saveTwitter(twitterContent);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        TwitterContent twitterContent = this.getAndCheckIDandObject(toolContentId);
        twitterContent.setForceOffline(value);
        this.saveTwitter(twitterContent);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        TwitterContent twitterContent = this.getAndCheckIDandObject(toolContentId);
        if (!twitterContent.getTwitterSessions().isEmpty() && !removeSessionData) {
            throw new SessionDataExistsException("Delete failed: There is session data that belongs to this tool content id");
        }
        Set attachments = twitterContent.getTwitterAttachments();
        Iterator i = attachments.iterator();
        while (i.hasNext()) {
            try {
                this.removeAttachment(twitterContent, (TwitterAttachment)i.next());
            }
            catch (RepositoryCheckedException e) {}
        }
        this.removeTwitter(toolContentId);
    }

    private TwitterContent getAndCheckIDandObject(Long toolContentId) throws ToolException, DataMissingException {
        if (toolContentId == null) {
            throw new ToolException("Tool content ID is missing. Unable to continue");
        }
        TwitterContent twitterContent = this.retrieveTwitter(toolContentId);
        if (twitterContent == null) {
            throw new DataMissingException("No tool content matches this tool content id");
        }
        return twitterContent;
    }

    private TwitterSession getAndCheckSessionIDandObject(Long toolSessionId) throws ToolException, DataMissingException {
        if (toolSessionId == null) {
            throw new ToolException("Tool session ID is missing. Unable to continue");
        }
        TwitterSession twitterSession = this.retrieveTwitterSession(toolSessionId);
        if (twitterSession == null) {
            throw new DataMissingException("No tool session matches this tool session id");
        }
        return twitterSession;
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        TwitterContent toolContentObj = this.twitterContentDAO.findTwitterContentById(toolContentId);
        if (toolContentObj == null) {
            Long defaultContentId = this.getToolDefaultContentIdBySignature("fptwit10");
            toolContentObj = this.retrieveTwitter(defaultContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the twitter tool");
        }
        try {
            toolContentObj = TwitterContent.newInstance(toolContentObj, toolContentId, null);
            toolContentObj.setTwitterSessions(null);
            this.exportContentService.registerFileClassForExport(TwitterAttachment.class.getName(), "uuid", "versionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, this.twitterToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new ToolException((Throwable)e);
        }
        catch (RepositoryCheckedException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(TwitterAttachment.class.getName(), "uuid", "versionId", "filename", "fileProperty", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.twitterToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof TwitterContent)) {
                throw new ImportToolContentException("Import Noteice board tool content failed. Deserialized object is " + toolPOJO);
            }
            TwitterContent toolContentObj = (TwitterContent)toolPOJO;
            toolContentObj.setTwitterContentId(toolContentId);
            this.twitterContentDAO.saveTwitterContent(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId, int definitionType) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (toolSessionId == null || toolContentId == null) {
            String error = "Failed to create tool session. The tool session id or tool content id is invalid";
            throw new ToolException(error);
        }
        this.twitterContent = this.retrieveTwitter(toolContentId);
        if (this.twitterContent == null) {
            TwitterContent defaultContent = this.retrieveTwitter(this.getToolDefaultContentIdBySignature("fptwit10"));
            if (defaultContent == null) throw new ToolException("Default content is missing. Unable to create tool session");
            TwitterSession newSession = new TwitterSession(toolSessionId, toolSessionName, defaultContent, new Date(System.currentTimeMillis()), "NOT_ATTEMPTED");
            defaultContent.getTwitterSessions().add(newSession);
            this.saveTwitter(defaultContent);
            return;
        } else {
            TwitterSession twitterSession = new TwitterSession(toolSessionId, toolSessionName, this.twitterContent, new Date(System.currentTimeMillis()), "NOT_ATTEMPTED");
            this.twitterContent.getTwitterSessions().add(twitterSession);
            this.saveTwitter(this.twitterContent);
        }
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        this.getAndCheckSessionIDandObject(toolSessionId);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws ToolException, DataMissingException {
        this.getAndCheckSessionIDandObject(toolSessionId);
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws ToolException, DataMissingException {
        Iterator i = toolSessionIds.iterator();
        if (i.hasNext()) {
            Long id = (Long)i.next();
            this.getAndCheckSessionIDandObject(id);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        TwitterSession session = this.getAndCheckSessionIDandObject(toolSessionId);
        this.removeSession(session);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        TwitterContent toolContentObj = new TwitterContent();
        String content = WebUtil.convertNewlines((String)((String)importValues.get("body")));
        toolContentObj.setContent(content);
        toolContentObj.setContentInUse(false);
        toolContentObj.setCreatorUserId(user.getUserID().longValue());
        toolContentObj.setDateCreated(now);
        toolContentObj.setDateUpdated(now);
        toolContentObj.setDefineLater(false);
        toolContentObj.setForceOffline(false);
        toolContentObj.setTwitterContentId(toolContentId);
        toolContentObj.setOfflineInstructions(null);
        toolContentObj.setOnlineInstructions(null);
        toolContentObj.setTitle((String)importValues.get("title"));
        toolContentObj.setReflectOnActivity(false);
        this.twitterContentDAO.saveTwitterContent(toolContentObj);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        TwitterContent toolContentObj = this.retrieveTwitter(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    @Override
    public Long getToolDefaultContentIdBySignature(String toolSignature) {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = "Could not retrieve default content id for this tool";
            log.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        return contentId;
    }

    public void setTwitterContentDAO(ITwitterContentDAO twitterContentDAO) {
        this.twitterContentDAO = twitterContentDAO;
    }

    public void setTwitterSessionDAO(ITwitterSessionDAO twitterSessionDAO) {
        this.twitterSessionDAO = twitterSessionDAO;
    }

    public void setTwitterUserDAO(ITwitterUserDAO twitterUserDAO) {
        this.twitterUserDAO = twitterUserDAO;
    }

    public void setTwitterUserTweetDAO(ITwitterUserTweetDAO twitterUserTweetDAO) {
        this.twitterUserTweetDAO = twitterUserTweetDAO;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setTwitterAttachmentDAO(ITwitterAttachmentDAO twitterAttachmentDAO) {
        this.twitterAttachmentDAO = twitterAttachmentDAO;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IToolContentHandler getTwitterToolContentHandler() {
        return this.twitterToolContentHandler;
    }

    public void setTwitterToolContentHandler(IToolContentHandler twitterToolContentHandler) {
        this.twitterToolContentHandler = twitterToolContentHandler;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public Class[] getSupportedToolOutputDefinitionClasses(int definitionType) {
        return null;
    }
}

