/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.twitter.TwitterApplicationException;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;
import org.lamsfoundation.lams.tool.twitter.TwitterUser;
import org.lamsfoundation.lams.tool.twitter.TwitterUserTweet;
import org.lamsfoundation.lams.tool.twitter.service.ITwitterService;
import org.lamsfoundation.lams.tool.twitter.service.TwitterServiceProxy;
import org.lamsfoundation.lams.tool.twitter.util.TwitterWebUtil;
import org.lamsfoundation.lams.tool.twitter.web.TwitterLearnerForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class TwitterLearnerStarterAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)TwitterLearnerStarterAction.class.getName());

    private UserDTO getUserDTO(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        return user;
    }

    public Long getUserID(HttpServletRequest request) {
        UserDTO user = this.getUserDTO(request);
        return new Long(user.getUserID().longValue());
    }

    public Long getUserIDFromURLCall(HttpServletRequest request) {
        return WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.learner(mapping, form, request, response);
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        HttpSession session = request.getSession(true);
        TwitterContent twitterContent = null;
        TwitterUser twitterUser = null;
        this.saveMessages(request, null);
        TwitterLearnerForm learnerForm = (TwitterLearnerForm)form;
        learnerForm.setTweet("");
        ActionMessages message = new ActionMessages();
        ITwitterService twitterService = TwitterServiceProxy.getTwitterService(this.getServlet().getServletContext());
        Long toolSessionID = TwitterWebUtil.convertToLong(learnerForm.getToolSessionID());
        if (toolSessionID == null) {
            String error = "Unable to continue. The parameters tool session id is missing";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        twitterContent = twitterService.retrieveTwitterBySessionID(toolSessionID);
        if (twitterContent == null) {
            String error = "An Internal error has occurred. Please exit and retry this sequence";
            logger.error((Object)error);
            throw new TwitterApplicationException(error);
        }
        if (this.isFlagSet(twitterContent, 1)) {
            return mapping.findForward("defineLater");
        }
        boolean readOnly = false;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        if (session.getAttribute("twitterUsername") == null || session.getAttribute("twitterPassword") == null) {
            return mapping.findForward("showTwitter");
        }
        Long userID = null;
        if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR) {
            userID = this.getUserID(request);
            twitterUser = twitterService.retrieveTwitterUserBySession(userID, toolSessionID);
            if (!twitterContent.isContentInUse()) {
                twitterContent.setContentInUse(true);
                twitterService.saveTwitter(twitterContent);
            }
            if (twitterUser == null) {
                twitterUser = new TwitterUser(userID);
                UserDTO user = this.getUserDTO(request);
                twitterUser.setUsername(user.getLogin());
                twitterUser.setFullname(user.getFirstName() + " " + user.getLastName());
                twitterService.addUser(toolSessionID, twitterUser);
            }
        } else {
            userID = this.getUserIDFromURLCall(request);
            twitterUser = twitterService.retrieveTwitterUserBySession(userID, toolSessionID);
            readOnly = true;
        }
        int currentTweets = twitterService.retrieveNumberOfTweetsByUser(userID, twitterContent.getUid());
        learnerForm.setContentID(twitterContent.getUid().toString());
        learnerForm.setUserID(twitterUser.getUid().toString());
        learnerForm.setTwitterUsername(session.getAttribute("twitterUsername").toString());
        TwitterUserTweet[] userTweets = request.getAttribute("tweetMode") == "user" ? twitterService.retrieveTwitterUserTweetByUser(userID, twitterContent.getUid()) : twitterService.retrieveTwitterUserTweet(twitterContent.getUid());
        learnerForm.copyValuesIntoForm(twitterContent, readOnly, mode.toString(), userTweets, currentTweets);
        NotebookEntry notebookEntry = twitterService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "fptwit10", userID.intValue());
        if (notebookEntry != null) {
            request.setAttribute("reflectEntry", (Object)notebookEntry.getEntry());
        }
        request.setAttribute("reflectInstructions", (Object)twitterContent.getReflectInstructions());
        request.setAttribute("reflectOnActivity", (Object)twitterContent.getReflectOnActivity());
        Boolean userFinished = twitterUser != null && "COMPLETED".equals(twitterUser.getUserStatus());
        request.setAttribute("userFinished", (Object)userFinished);
        if (this.displayMessageToUser(twitterContent, message)) {
            this.saveMessages(request, message);
            return mapping.findForward("displayMessage");
        }
        return mapping.findForward("displayLearnerContent");
    }

    public ActionForward teacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        return this.learner(mapping, form, request, response);
    }

    public ActionForward author(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws TwitterApplicationException {
        return this.learner(mapping, form, request, response);
    }

    private boolean isFlagSet(TwitterContent content, int flag) throws TwitterApplicationException {
        switch (flag) {
            case 1: {
                return content.isDefineLater();
            }
            case 2: {
                return content.isContentInUse();
            }
            case 3: {
                return content.isForceOffline();
            }
        }
        throw new TwitterApplicationException("Invalid flag");
    }

    private boolean displayMessageToUser(TwitterContent content, ActionMessages message) {
        boolean isDefineLaterSet = this.isFlagSet(content, 1);
        boolean isRunOfflineSet = this.isFlagSet(content, 3);
        if (isDefineLaterSet || isRunOfflineSet) {
            if (isDefineLaterSet) {
                message.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.defineLaterSet"));
            }
            if (isRunOfflineSet) {
                message.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.runOfflineSet"));
            }
            return true;
        }
        return false;
    }
}

