/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.twitter;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.lamsfoundation.lams.tool.twitter.TwitterContent;

public class TwitterSession
implements Serializable {
    public static final String NOT_ATTEMPTED = "NOT_ATTEMPTED";
    public static final String INCOMPLETE = "INCOMPLETE";
    public static final String COMPLETED = "COMPLETED";
    private Long uid;
    private Long twitterSessionId;
    private String twitterSessionName;
    private Date sessionStartDate;
    private Date sessionEndDate;
    private String sessionStatus;
    private TwitterContent twitterContent;
    private Set twitterUsers = new HashSet();

    public TwitterSession() {
    }

    public TwitterSession(Long twitterSessionId, String twitterSessionName, TwitterContent twitterContent, Date sessionStartDate, Date sessionEndDate, String sessionStatus) {
        this.twitterSessionId = twitterSessionId;
        this.twitterSessionName = twitterSessionName;
        this.twitterContent = twitterContent;
        this.sessionStartDate = sessionStartDate;
        this.sessionEndDate = sessionEndDate;
        this.sessionStatus = sessionStatus;
    }

    public TwitterSession(Long twitterSessionId, String twitterSessionName, TwitterContent twitterContent, Date sessionStartDate, String sessionStatus) {
        this.twitterSessionId = twitterSessionId;
        this.twitterSessionName = twitterSessionName;
        this.twitterContent = twitterContent;
        this.sessionStartDate = sessionStartDate;
        this.sessionEndDate = null;
        this.sessionStatus = sessionStatus;
    }

    public TwitterSession(Long twitterSessionId, String twitterSessionName, TwitterContent twitterContent) {
        this.twitterSessionId = twitterSessionId;
        this.twitterSessionName = twitterSessionName;
        this.twitterContent = twitterContent;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public TwitterSession(Long twitterSessionId, String twitterSessionName) {
        this.twitterSessionId = twitterSessionId;
        this.twitterSessionName = twitterSessionName;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public TwitterSession(Long twitterSessionId) {
        this.twitterSessionId = twitterSessionId;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public TwitterContent getTwitterContent() {
        return this.twitterContent;
    }

    public void setTwitterContent(TwitterContent twitterContent) {
        this.twitterContent = twitterContent;
    }

    public Long getTwitterSessionId() {
        return this.twitterSessionId;
    }

    public void setTwitterSessionId(Long twitterSessionId) {
        this.twitterSessionId = twitterSessionId;
    }

    public String getTwitterSessionName() {
        return this.twitterSessionName;
    }

    public void setTwitterSessionName(String twitterSessionName) {
        this.twitterSessionName = twitterSessionName;
    }

    public Date getSessionEndDate() {
        return this.sessionEndDate;
    }

    public void setSessionEndDate(Date sessionEndDate) {
        this.sessionEndDate = sessionEndDate;
    }

    public Date getSessionStartDate() {
        return this.sessionStartDate;
    }

    public void setSessionStartDate(Date sessionStartDate) {
        this.sessionStartDate = sessionStartDate;
    }

    public String getSessionStatus() {
        return this.sessionStatus;
    }

    public void setSessionStatus(String sessionStatus) {
        this.sessionStatus = sessionStatus;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Set getTwitterUsers() {
        if (this.twitterUsers == null) {
            this.setTwitterUsers(new HashSet());
        }
        return this.twitterUsers;
    }

    public void setTwitterUsers(Set twitterUsers) {
        this.twitterUsers = twitterUsers;
    }
}

